/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.client.gui.GuiCustomList;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.widget.list.KeyBindingList;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiFreeKeysList
extends GuiCustomList {
    private final ControlsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    List<KeyBinding> keyBindings;

    public GuiFreeKeysList(ControlsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.field_230670_d_ = controls.field_230708_k_ + 45;
        this.field_230671_e_ = controls.field_230709_l_;
        this.field_230672_i_ = 43;
        this.field_230673_j_ = controls.field_230709_l_ - 80;
        this.field_230674_k_ = controls.field_230708_k_ + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.func_231039_at__().clear();
        this.allEntries = new ArrayList();
        this.keyBindings = Arrays.stream(this.mc.field_71474_y.field_74324_K).collect(Collectors.toList());
        this.recalculate();
    }

    public void recalculate() {
        this.func_231039_at__().clear();
        this.allEntries.clear();
        this.add(new HeaderEntry("Available Keys"));
        InputMappings.Input.field_199875_d.values().stream().filter(input -> !input.toString().startsWith("key.keyboard.world")).sorted(Comparator.comparing(o -> o.func_237520_d_().getString())).forEach(input -> {
            if (this.keyBindings.stream().noneMatch(keyBinding -> keyBinding.getKey().equals(input))) {
                int i = this.mc.field_71466_p.func_78256_a(input.func_237520_d_().getString());
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
                this.add(new InputEntry((InputMappings.Input)input));
            }
        });
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 20;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeaderEntry
    extends KeyBindingList.Entry {
        private final String text;

        public HeaderEntry(String text) {
            this.text = text;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of();
        }

        public void func_230432_a_(MatrixStack stack, int slotIndex, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            AbstractGui.func_238475_b_((MatrixStack)stack, (FontRenderer)((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71466_p, (ITextComponent)new TranslationTextComponent("options.availableKeys"), (int)(((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71462_r.field_230708_k_ / 2 - this.text.length() / 2), (int)(y + p_render_5_ - 9 - 1), (int)0xFFFFFF);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class InputEntry
    extends KeyBindingList.Entry {
        private final InputMappings.Input input;

        public InputEntry(InputMappings.Input input) {
            this.input = input;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of();
        }

        public InputMappings.Input getInput() {
            return this.input;
        }

        public void func_230432_a_(MatrixStack stack, int slotIndex, int y, int x, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            String str = this.input.toString() + " - " + this.input.func_197937_c();
            int length = ((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71466_p.func_78256_a(this.input.func_237520_d_().getString());
            ((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71466_p.func_238421_b_(stack, str, (float)x, (float)(y + p_render_5_ / 2 - 4), 0xFFFFFF);
            GuiUtils.drawHoveringText((MatrixStack)stack, Collections.singletonList(this.input.func_237520_d_()), (int)(x + p_render_4_ - length), (int)(y + p_render_5_), (int)((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71462_r.field_230708_k_, (int)((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71462_r.field_230709_l_, (int)-1, (FontRenderer)((GuiFreeKeysList)GuiFreeKeysList.this).mc.field_71466_p);
        }
    }
}

